import flash.MovieClip;
import events.Event;
import events.EventDispatcher;
import events.EventListener;


class PlayerButton extends MovieClip
{

  public var id(default, null):String;
  private var dispatcher:EventDispatcher;

  public function new () 
  {
    this._alpha = 60;
    dispatcher = new EventDispatcher(this);

  }

  override public function onRollOver ():Void 
  {
    this._alpha = 100;
  }
  override public function onRollOut ():Void 
  {
    this._alpha = 60;
  }

  //Následující část řeší spouštění událostí v této třídě. Jedná se o metody třídy events.EventDispatcher. 

  public function getParent():PlayerButton {
    return cast(_parent, PlayerButton);
  }

  public function addEventListener(type:EventType, handler:Dynamic, context:Dynamic):Void {
    dispatcher.addEventListener(type, handler, context);
  }

  public function removeEventListener(type:EventType, handler:Dynamic, context:Dynamic):EventListener {
    return dispatcher.removeEventListener(type, handler, context);
  }

  public function dispatchEvent(event:Event):Bool {
    var dispatched:Bool = dispatcher.dispatchEvent(event);
    if(event.bubbles && dispatched && getParent() != null) {
      getParent().dispatchEvent(event);
    }
    return dispatched;
  }

}
